package org.simantics.modeling.tests.traits;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class UriResourceTrait extends AbstractSingleResourceTrait {
	
	public SingleResourceTrait base;
	public String suffix;
	
	public UriResourceTrait(SingleResourceTrait base, String suffix) {
		this.base = base;
		this.suffix = suffix;
	}
	
	@Override
	public Resource getResource(ReadGraph graph) throws DatabaseException {
		return graph.getResource(graph.getURI(base.getResource()) + suffix);
	}
	
}
