package org.simantics.modeling.tests.commands;

import java.util.Set;

import junit.framework.Assert;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.issues.common.IssuesWithContext;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;


public class AssertIssueCount extends WriteCommand<ModelingCommandSequenceTest> {

	private AddModule module;
	private int expected;
	
	public AssertIssueCount(AddModule module, int expected) {
		this.module = module;
		this.expected = expected;
	}
	
	@Override
	protected void run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
		
        Resource element = module.getResource();
        Resource component = graph.getSingleObject(element, ModelingResources.getInstance(graph).ElementToComponent);
        Set<Variable> issues = graph.sync(new IssuesWithContext(graph, component));

        Assert.assertEquals(expected, issues.size());
        
	}

}