/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.simantics.message.internal;

import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.simantics.message.IDetailStatus;
import org.simantics.message.ILogListener;

/**
 * A log writer that writes log entries. See PlatformLogReader for reading logs
 * back into memory.
 * <p>
 * Note that this class just provides a bridge from the old ILog interface to
 * the OSGi FrameworkLog interface.
 * </p>
 * 
 * <p>
 * Copied from <code>org.eclipse.core.internal.runtime.PlatformLogWriter</code>
 * since the code was internal to eclipse. Support for {@link IDetailStatus} has
 * been added.
 * </p>
 */
public class LogWriter implements ILogListener {
    private final FrameworkLog frameworkLog;

    public LogWriter(FrameworkLog frameworkLog) {
        this.frameworkLog = frameworkLog;
    }

    /**
     * @see ILogListener#logging(IStatus, String)
     */
    public synchronized void logging(IStatus status, String plugin) {
        frameworkLog.log(getLog(status));
    }

    protected FrameworkLogEntry getLog(IStatus status) {
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();

        int stackCode = t instanceof CoreException ? 1 : 0;
        // ensure a substatus inside a CoreException is properly logged
        if (stackCode == 1) {
            IStatus coreStatus = ((CoreException) t).getStatus();
            if (coreStatus != null) {
                childlist.add(getLog(coreStatus));
            }
        }

        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            for (int i = 0; i < children.length; i++) {
                childlist.add(getLog(children[i]));
            }
        }

        FrameworkLogEntry[] children = (childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]));

        String message = status.getMessage();
        if (status instanceof IDetailStatus) {
            IDetailStatus ds = (IDetailStatus) status;
            message = message + "\n!DETAILS " + ds.getDetailedDescription();
        }

        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), message, stackCode, t, children);
    }
}
