/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class TypedBracketInstruction
implements IInstruction {
    IInstruction instruction;
    CreationInstruction[] variables;

    public TypedBracketInstruction(IInstruction instruction, CreationInstruction ... variables) {
        this.instruction = instruction;
        this.variables = variables;
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.instruction.collectVariables(reads, writes);
        CreationInstruction[] creationInstructionArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CreationInstruction var = creationInstructionArray[n2];
            var.collectVariables(reads, writes);
            ++n2;
        }
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        if (this.instruction.query(g, bindings) == IInstruction.FAILURE) {
            return new Claim();
        }
        return null;
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        Object continuation = this.instruction.query(g, bindings);
        if (continuation != IInstruction.FAILURE) {
            return new Deny(continuation);
        }
        return null;
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        if (this.instruction.query((ReadGraph)g, bindings) == IInstruction.FAILURE) {
            CreationInstruction[] creationInstructionArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                CreationInstruction var = creationInstructionArray[n2];
                bindings[var.variableId] = var.create(g, bindings);
                ++n2;
            }
            this.instruction.doClaim(g, bindings);
        }
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        Object continuation = this.instruction.query((ReadGraph)g, bindings);
        if (continuation != IInstruction.FAILURE) {
            do {
                CreationInstruction[] creationInstructionArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    CreationInstruction var = creationInstructionArray[n2];
                    g.deny((Resource)bindings[var.variableId]);
                    ++n2;
                }
            } while ((continuation = this.instruction.next((ReadGraph)g, bindings, continuation)) != null && continuation != IInstruction.FAILURE);
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.instruction.mapVariables(map);
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i].mapVariables(map);
            ++i;
        }
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
        return this.instruction.next(g, bindings, continuation);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        return this.instruction.query(g, bindings);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append('[');
        b.append(']');
    }

    class Claim
    implements IContextualModification {
        @Override
        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
            CreationInstruction[] creationInstructionArray = TypedBracketInstruction.this.variables;
            int n = TypedBracketInstruction.this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                CreationInstruction var = creationInstructionArray[n2];
                bindings[var.variableId] = var.create(g, bindings);
                ++n2;
            }
            TypedBracketInstruction.this.instruction.doClaim(g, bindings);
        }
    }

    public static abstract class CreationInstruction {
        protected int variableId;

        public CreationInstruction(int variableId) {
            this.variableId = variableId;
        }

        public abstract Resource create(WriteGraph var1, Object[] var2) throws DatabaseException;

        public void mapVariables(TIntIntHashMap map) {
            this.variableId = map.get(this.variableId);
        }

        public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        }
    }

    class Deny
    implements IContextualModification {
        Object continuation;

        public Deny(Object continuation) {
            this.continuation = continuation;
        }

        @Override
        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
            do {
                CreationInstruction[] creationInstructionArray = TypedBracketInstruction.this.variables;
                int n = TypedBracketInstruction.this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    CreationInstruction var = creationInstructionArray[n2];
                    g.deny((Resource)bindings[var.variableId]);
                    ++n2;
                }
                this.continuation = TypedBracketInstruction.this.instruction.next((ReadGraph)g, bindings, this.continuation);
            } while (this.continuation != null && this.continuation != IInstruction.FAILURE);
        }
    }
}

