package org.simantics.operation;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class OperationResource {
    
    public final Resource AbstractContextualList;
    public final Resource ConditionalList;
    public final Resource ContextualList;
    public final Resource HasCondition;
    public final Resource HasElseElement;
    public final Resource HasThenElement;
    public final Resource Operation;
    public final Resource TypeBasedList;
        
    public static class URIs {
        public static final String AbstractContextualList = "http://www.simantics.org/Layer0X-1.1/Operation/AbstractContextualList";
        public static final String ConditionalList = "http://www.simantics.org/Layer0X-1.1/Operation/ConditionalList";
        public static final String ContextualList = "http://www.simantics.org/Layer0X-1.1/Operation/ContextualList";
        public static final String HasCondition = "http://www.simantics.org/Layer0X-1.1/Operation/HasCondition";
        public static final String HasElseElement = "http://www.simantics.org/Layer0X-1.1/Operation/HasElseElement";
        public static final String HasThenElement = "http://www.simantics.org/Layer0X-1.1/Operation/HasThenElement";
        public static final String Operation = "http://www.simantics.org/Layer0X-1.1/Operation/Operation";
        public static final String TypeBasedList = "http://www.simantics.org/Layer0X-1.1/Operation/TypeBasedList";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public OperationResource(ReadGraph graph) {
        AbstractContextualList = getResourceOrNull(graph, URIs.AbstractContextualList);
        ConditionalList = getResourceOrNull(graph, URIs.ConditionalList);
        ContextualList = getResourceOrNull(graph, URIs.ContextualList);
        HasCondition = getResourceOrNull(graph, URIs.HasCondition);
        HasElseElement = getResourceOrNull(graph, URIs.HasElseElement);
        HasThenElement = getResourceOrNull(graph, URIs.HasThenElement);
        Operation = getResourceOrNull(graph, URIs.Operation);
        TypeBasedList = getResourceOrNull(graph, URIs.TypeBasedList);
    }
    
    public static OperationResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        OperationResource ret = session.peekService(OperationResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new OperationResource(qc.getIndependentGraph(graph));
            session.registerService(OperationResource.class, ret);
        }
        return ret;
    }
    
    public static OperationResource getInstance(RequestProcessor session) throws DatabaseException {
        OperationResource ret = session.peekService(OperationResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<OperationResource>() {
                public OperationResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new OperationResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(OperationResource.class, ret);
        }
        return ret;
    }
    
}

