/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.instantiation;

import java.util.Collection;

import org.simantics.db.Resource;

/**
 * Helper class for creating multi-instances.
 * Note : This does NOT check conflicting requirements. 
 * 
 * @author Marko Luukkainen <Marko.Luukkainen@vtt.fi>
 *
 */
public class MultiInstance extends Instance {
	
	public MultiInstance(Collection<Instance> instances, Resource instanceOf) {
		for (Instance i : instances) {
			if (i.equals != null)
				throw new UnsupportedOperationException("Don't know how to handle equal instances.");
			for (RelatedInstance ri : i.relatedInstances) {
				boolean contains = false;
				for (RelatedInstance cri : relatedInstances) {
					if (cri.relation == ri.relation &&
						cri.relation != instanceOf) {
						contains = true;
						break;
					}
				}
				if(!contains) {
					relatedInstances.add(ri);
				}
			}
		}
	}

}
