/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.direct;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;

public class ExceptionUtils {
    
    public static <T> void decipher(AsyncReadGraph graph, Throwable throwable, final AsyncProcedure<T> procedure) {

        if(throwable instanceof DatabaseException) {

            System.out.println("decipher " + throwable);
            
            final DatabaseException e = (DatabaseException)throwable;
            
            Collection<Resource> resources = e.getResources();
            if(resources != null) {

                graph.asyncRequest(new Read<ArrayList<String>>() {
    
                    @Override
                    public ArrayList<String> perform(ReadGraph graph) throws DatabaseException {
                        
                        Collection<Resource> resources = e.getResources();
                        ArrayList<String> names = new ArrayList<String>();
                        
                        for(Resource r : resources) {
                            names.add(NameUtils.getSafeName(graph, r));
                        }
    
                        return names;
                        
                    }
                    
                }, new AsyncProcedure<ArrayList<String>>() {
    
                    @Override
                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        procedure.exception(graph, throwable);
                    }
    
                    @Override
                    public void execute(AsyncReadGraph graph, ArrayList<String> names) {
                        e.setNames(names);
                        procedure.exception(graph, e);
                    }
                    
                });
                
            } else {
                
                procedure.exception(graph, throwable);

            }
            
        } else {
            
            procedure.exception(graph, throwable);

        }
        
    }

}
