/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.binaryPredicates;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Pair;

public interface IBinaryPredicate {

	boolean supportsGetObjects();
	boolean supportsGetSubjects();
	boolean supportsGetStatements();	
	
	Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException;
	Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException;
	Collection<Pair<Resource,Resource>> getStatements(ReadGraph g) throws DatabaseException;
	boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException;

	boolean supportsAdditions();
	boolean supportsRemovals();
	
	void add(WriteGraph g, Resource subject, Resource object) throws DatabaseException;
	void remove(WriteGraph g, Resource subject, Resource object) throws DatabaseException;
	
	IBinaryPredicate inverse(ReadGraph g) throws DatabaseException;
	
	String toString(ReadGraph g) throws DatabaseException;
	
}
