/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.tests.conversion;

import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

/**
 * @author Hannu Niemist&ouml;
 * @deprecated superceded by {@link TransferableGraph1}
 */
@Deprecated
public class TransferableGraph0 {
	public static Binding BINDING = Bindings.getBindingUnchecked(TransferableGraph0.class);
	public static Serializer SERIALIZER = Bindings.getSerializerUnchecked(BINDING);
	
	public int resourceCount;	
	public Identity[] identities;	
	public int[] statements;
	public Value[] values;	
	public TreeMap<String, Variant> extensions;
	
	public TransferableGraph0() {     
    }
	
	public TransferableGraph0(int resourceCount, Identity[] identities,
			int[] statements, Value[] values) {
		this(resourceCount, identities, statements, values,
				new TreeMap<String, Variant>());
	}
	
	public TransferableGraph0(int resourceCount, Identity[] identities,
			int[] statements, Value[] values, TreeMap<String, Variant> extensions) {
		this.resourceCount = resourceCount;
		this.identities = identities;
		this.statements = statements;
		this.values = values;
		this.extensions = extensions;
	}
}
