package org.simantics.graph.refactoring;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.representation.Extensions;
import org.simantics.graph.representation.TransferableGraph1;

/**
 * @author Tuukka Lehtonen
 * @since 1.34.0
 */
public class TransferableGraphHasher {

	public static int hashTG(TransferableGraph1 tg) throws BindingException {
		return TransferableGraph1.BINDING.hashValue(tg);
	}

	public static DataContainer addHashToTG(DataContainer tgContainer, TransferableGraph1 tg) throws BindingException {
		Binding tgb = TransferableGraph1.BINDING;
		tgContainer.metadata.put(Extensions.CACHED_HASHCODE, new Variant(Bindings.INTEGER, hashTG(tg)));
		tgContainer.content = new Variant(tgb, tg);
		return tgContainer;
	}

	public static DataContainer addHashToTG(DataContainer tgContainer) throws BindingException, AdaptException {
		return addHashToTG(tgContainer, (TransferableGraph1) tgContainer.content.getValue(TransferableGraph1.BINDING));
	}

	public static void hashTG(Path input, Path output) throws Exception {
		System.out.format("Adding cached hash value to transferable graph%n\t" + input.toString() + "%nto%n\t" + output.toString());
		DataContainers.writeFile(output.toFile(),
				addHashToTG(
						DataContainers.readFile(input.toFile(), TransferableGraph1.BINDING) ));
	}

	public static void main(String[] args) throws Exception {
		if (args.length == 0) {
			System.out.println("Required arguments: <input graph.tg file> [<output .tg file>]");
		} else if (args.length == 1) {
			// In-place hash
			Path p = Paths.get(args[0]);
			hashTG(p, p);
		} else {
			hashTG(Paths.get(args[0]), Paths.get(args[1]));
		}
	}

}
