/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

public interface TGStatusMonitor {
    public static final TGStatusMonitor NULL_MONITOR = new NullMonitor();

    public void status(int var1);

    public boolean isCanceled();

    public static int updatePercentage(TGStatusMonitor monitor, int low, int high, int oldPercentage, int done, int total) {
        int range = high - low;
        int current = low + range * done / total;
        if (current != oldPercentage) {
            oldPercentage = current;
            if (monitor != null) {
                monitor.status(oldPercentage);
            }
        }
        return oldPercentage;
    }

    public static class NullMonitor
    implements TGStatusMonitor {
        @Override
        public void status(int percentage) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }
    }

    public static class Updater {
        private final TGStatusMonitor monitor;
        private final int total;
        private int low;
        private int high;
        private int current;
        private int worked;

        public Updater(TGStatusMonitor monitor, int lowPercentage, int highPercentage, int totalWork) {
            this.monitor = monitor;
            this.low = lowPercentage;
            this.high = highPercentage;
            this.total = totalWork;
        }

        public int worked(int work) {
            this.worked += work;
            this.current = TGStatusMonitor.updatePercentage(this.monitor, this.low, this.high, this.current, this.worked, this.total);
            return this.current;
        }
    }
}

