/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.utils;

import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.INode;
import org.simantics.utils.datastructures.BijectionMap;

/**
 * @author Tuukka Lehtonen
 */
public class ElementNodeBridge extends BijectionMap<IElement, INode> {

    Object id;

    public ElementNodeBridge(Object id) {
        this.id = id;
    }

    private ElementNodeBridge(Object id, BijectionMap<IElement, INode> selection) {
        super(selection);
        this.id = id;
    }

    @Override
    public ElementNodeBridge clone() {
        return new ElementNodeBridge(this.id, this);
    }

    public Object getId() {
        return id;
    }

    public void remove(IElement element) {
        removeWithLeft(element);
    }

    public void remove(INode node) {
        removeWithRight(node);
    }

}
