/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.page;

import org.simantics.utils.page.PageDesc;

/**
 * @author Marko Luukkainen
 */
public class DiagramDesc {

    private final PageDesc pageDesc;
    private final double   gridSize;
    private final boolean  pageBordersVisible;
    private final boolean  marginsVisible;

    // Global settings
    private final boolean  gridVisible;
    private final boolean  rulerVisible;

    public DiagramDesc(PageDesc pageDesc, double gridSize, boolean pageBordersVisible, boolean marginsVisible, boolean gridVisible, boolean rulerVisible) {
        this.pageDesc = pageDesc;
        this.gridSize = gridSize;
        this.pageBordersVisible = pageBordersVisible;
        this.marginsVisible = marginsVisible;
        this.gridVisible = gridVisible;
        this.rulerVisible = rulerVisible;
    }

    public PageDesc getPageDesc() {
        return pageDesc;
    }

    public double getGridSize() {
        return gridSize;
    }

    public boolean isPageBordersVisible() {
        return pageBordersVisible;
    }

    public boolean isMarginsVisible() {
        return marginsVisible;
    }

    public boolean isGridVisible() {
        return gridVisible;
    }

    public boolean isRulerVisible() {
        return rulerVisible;
    }

    public DiagramDesc withPageDesc(PageDesc pageDesc) {
        return new DiagramDesc(pageDesc, gridSize, pageBordersVisible, marginsVisible, gridVisible, rulerVisible);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((pageDesc == null) ? 0 : pageDesc.hashCode());
        long temp;
        temp = Double.doubleToLongBits(gridSize);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        result = prime * result + (marginsVisible ? 1231 : 1237);
        result = prime * result + (pageBordersVisible ? 1231 : 1237);
        result = prime * result + (gridVisible ? 1231 : 1237);
        result = prime * result + (rulerVisible ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DiagramDesc other = (DiagramDesc) obj;
        if (pageDesc == null) {
            if (other.pageDesc != null)
                return false;
        } else if (!pageDesc.equals(other.pageDesc))
            return false;
        if (Double.doubleToLongBits(gridSize) != Double.doubleToLongBits(other.gridSize))
            return false;
        if (marginsVisible != other.marginsVisible)
            return false;
        if (pageBordersVisible != other.pageBordersVisible)
            return false;
        if (gridVisible != other.gridVisible)
            return false;
        if (rulerVisible != other.rulerVisible)
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "[gridSize=" + gridSize + ", pageBordersVisible=" + pageBordersVisible + ", marginsVisible=" + marginsVisible + ", gridVisible=" + gridVisible + ", rulerVisible=" + rulerVisible + ", pageDesc=" + pageDesc + "]"; 
    }

}
