/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.imageio.ImageIO;

import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ImageUtils;
import org.simantics.g2d.svg.SVGImage;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.ProvisionException;

/**
 * Creates images at an URL.
 * 
 * @See {@link ImageUtils}
 * @author Toni Kalajainen
 * @deprecated does not work with org.simantics.scenegraph
 */
@Deprecated
public class ImageURLFactory implements IFactory<Image> {

    URL url;

    public ImageURLFactory(URL url)
    {
        if (url==null) throw new IllegalArgumentException("null arg");
        this.url = url;
    }
    
    public static Image loadFromURL(String nodeIdentifier, URL url) throws IOException {
        try (InputStream in = url.openStream()) {
            return new SVGImage(nodeIdentifier, in);
        }
    }

    
    @Override
    public Image get() throws ProvisionException {
        boolean svg = url.getFile().toLowerCase().endsWith(".svg");

        if (svg) {
            try {
                // FIXME: provide nodeIdentifier argument from outside of the factory
                return SVGImage.loadFromURL(url.toString(), url);
            } catch (IOException e) {
                throw new ProvisionException(e);
            }
        }

        // Try opening with ImageIO
        try {
            BufferedImage bi = ImageIO.read(url);
            return new AWTImage(bi);
        } catch (IOException e) {
            throw new ProvisionException(e);
        }
    }

    @Override
    public int hashCode() {
        return url.hashCode() + 243243243;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (!obj.getClass().equals(getClass())) return false;
        return ((ImageURLFactory)obj).url.equals(url);
    }

}
