/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.utils.datastructures.cache.IProvider;

/**
 * AsyncImage acquires Image from IProvider asynchronously.
 * Wait symbol is shown while symbol is acquired.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class AsyncImage extends ImageProxy {

    static EnumSet<Feature> caps = EnumSet.of(Feature.Volatile, Feature.Vector);

    private static ThreadFactory tf = new ThreadFactory() {
        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(new ThreadGroup("Renderer"), r);
            t.setDaemon(false);
            return t;
        }
    };
    private static Executor EXECUTOR =
        new ThreadPoolExecutor(
                0,
                1,
                3L, TimeUnit.SECONDS,
                new LinkedBlockingQueue<Runnable>(),
                tf);

    public AsyncImage(final IProvider<Image> imgProvider) {
        super(DefaultImages.UNKNOWN.get());
        EXECUTOR.execute(new Runnable() {
            @Override
            public void run() {
                setSource(DefaultImages.GRAB.get());
                setSource(imgProvider.get());
            }});
    }

    @Override
    public EnumSet<Feature> getFeatures() {
        return EnumSet.of(Feature.Volatile);
    }

}

