/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import org.simantics.g2d.image.Image;
import org.simantics.utils.datastructures.ListenerList;

/**
 * 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public abstract class AbstractImage implements Image {

    ListenerList<ImageListener> list = null;

    @Override
    public void addImageListener(ImageListener listener) {
        getListenerList().add(listener);
    }

    @Override
    public void removeImageListener(ImageListener listener) {
        getListenerList().remove(listener);
    }

    protected void notifyChanged()
    {
        if (list == null)
            return;
        for (ImageListener l : list.getListeners())
            l.onContentChangedNotification(this);
    }

    private synchronized ListenerList<ImageListener> getListenerList()
    {
        if (list==null) list = new ListenerList<ImageListener>(ImageListener.class);
        return list;
    }
}

