/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.LifeCycle;

/**
 * @author Toni Kalajainen
 */
public class ProxyLifeCycle implements LifeCycle {

    private static final long serialVersionUID = 2222511223508932210L;

    LifeCycle orig;
    IProxyProvider provider;

    public ProxyLifeCycle(IProxyProvider provider, LifeCycle orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
        e = provider.provide(e);
        orig.onElementActivated(e.getDiagram(), e);
    }

    @Override
    public void onElementCreated(IElement e) {
        orig.onElementCreated(provider.provide(e));
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
        e = provider.provide(e);
        orig.onElementDeactivated(e.getDiagram(), e);
    }

    @Override
    public void onElementDestroyed(IElement e) {
        orig.onElementDestroyed(provider.provide(e));
    }


}
