/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Move;

/**
 * This implementation of Move transforms element variable ElementHints.KEY_TRANSFORM. 
 * 
 * @author Toni Kalajainen
 */
public class MoveImpl implements Move {

    private static final long serialVersionUID = 1395438821342445141L;

    public static final MoveImpl HANDLER = new MoveImpl(); 

    @Override
    public Point2D getPosition(IElement e) {
        AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
        Point2D p = new Point2D.Double(
                at.getTranslateX(),
                at.getTranslateY());
        return p;
    }

    @Override
    public void moveTo(IElement e, double x, double y) {		
        AffineTransform origAt = e.getHint(ElementHints.KEY_TRANSFORM);
        double oldX = origAt.getTranslateX();
        double oldY = origAt.getTranslateY();
        AffineTransform move = new AffineTransform();
        move.setToTranslation(x-oldX, y-oldY);
        AffineTransform at2 = new AffineTransform(origAt);
        at2.preConcatenate(move);
        e.setHint(ElementHints.KEY_TRANSFORM, at2);
    }


}
