/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

import org.simantics.g2d.utils.geom.DirectionSet;

/**
 * @author Tuukka Lehtonen
 */
public class BranchPointTerminal extends ObjectTerminal {

//    public static final Object NEW_BRANCH_POINT_DATA      = new Object();
    public static final Object EXISTING_BRANCH_POINT_DATA = new Object() {
        @Override
        public String toString() { return "EXISTING_BRANCH_POINT"; }
    };

    private BranchPointTerminal(Object o, AffineTransform transform, DirectionSet ds, Shape shape) {
        super(o, transform, ds, shape);
    }

//    public static BranchPointTerminal newTerminal(AffineTransform transform, DirectionSet ds, Shape shape) {
//        return new BranchPointTerminal(NEW_BRANCH_POINT_DATA, transform, ds, shape);
//    }

    public static BranchPointTerminal existingTerminal(AffineTransform transform, DirectionSet ds, Shape shape) {
        return new BranchPointTerminal(EXISTING_BRANCH_POINT_DATA, transform, ds, shape);
    }

    public static BranchPointTerminal existingTerminal(Point2D p, DirectionSet ds, Shape shape) {
        return existingTerminal(AffineTransform.getTranslateInstance(p.getX(), p.getY()), ds, shape);
    }

}