/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element;

import org.simantics.scenegraph.Node;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * A hint key class that should be used for defining hints that attach
 * org.simantics.scenegraph {@link Node}s to {@link IElement}s.
 * 
 * The reason for having this class is to be able to identify all hints
 * containing scene graph nodes, allowing for proper cleanup.
 * 
 * @author Tuukka Lehtonen
 */
final public class SceneGraphNodeKey extends KeyOf {

    public SceneGraphNodeKey(Class<?> clazz, String keyName) {
        super(clazz, keyName);
    }
    
    @Override
    public boolean isValueAccepted(Object value) {
    	return true;
    }

}
