/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import java.util.Collection;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.impl.PickContextImpl;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;

/**
 * Pick process is the following:
 *  1) Rough estimation with {@link InternalSize} 
 *  2) use {@link Pick} if implementations exist
 *  3) if pick doesn't exist, use {@link Outline} if implementations exist 
 * 
 * @see {@link PickContextImpl} Implementation
 * @author Toni Kalajainen
 */
public interface PickContext extends DiagramHandler {

	/**
	 * Make a pick to the diagram.
	 * Result content is added in z-order starting from the bottom.
	 * 
	 * @param diagram
	 * @param ctx
	 * @param request
	 * @param result
	 */
	void pick(
			IDiagram diagram, 
			PickRequest request, 
			Collection<IElement> result);	
	
}
