/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;

/**
 * Hooks events of adding / removing diagram to/from canvas.
 * <p>
 * This handler requires DiagramParticipant.
 * <p>
 * Note, diagram may be added to multiple canvases at the same time
 * 
 * @author Toni Kalajainen
 */
public interface CanvasListener extends DiagramHandler {

	public void onAddedToCanvas(IDiagram d, ICanvasContext canvas);
	public void onRemovedFromCanvas(IDiagram d, ICanvasContext canvas);
	
}
