/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.document.ui.actions.AddDocumentAction;
import org.simantics.document.ui.graphfile.FileDocumentUtil;

public class ImportDocument
extends AddDocumentAction {
    public ImportDocument(ReadGraph graph, String relationUri) throws DatabaseException {
        super(graph, relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.*"});
                if (dialog.open() == null) {
                    return;
                }
                String filterPath = dialog.getFilterPath();
                String[] filenames = dialog.getFileNames();
                ImportJob job = new ImportJob(filenames.length > 1 ? "Import files" : "Import file", resource, filterPath, filenames);
                job.setUser(true);
                job.schedule();
            }
        };
    }

    private class ImportJob
    extends DatabaseJob {
        Resource resource;
        String path;
        String[] filenames;

        public ImportJob(String name, Resource resource, String path, String[] filenames) {
            super(name);
            this.resource = resource;
            this.path = path;
            this.filenames = filenames;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            monitor.beginTask("Importing...", this.filenames.length);
            try {
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        try {
                            graph.markUndoPoint();
                            String[] stringArray = ImportJob.this.filenames;
                            int n = ImportJob.this.filenames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String filename = stringArray[n2];
                                File f = new File(ImportJob.this.path, filename);
                                Resource newDoc = FileDocumentUtil.importFileWithName(graph, f.getAbsolutePath());
                                ImportDocument.this.linkDocument(graph, ImportJob.this.resource, newDoc);
                                monitor.worked(1);
                                ++n2;
                            }
                        }
                        catch (Exception e) {
                            throw new DatabaseException((Throwable)e);
                        }
                    }
                });
                Status status = new Status(0, "org.simantics.document.ui", "Import succesful.");
                return status;
            }
            catch (DatabaseException e) {
                Status status = new Status(4, "org.simantics.document.ui", "Import failed.", (Throwable)e);
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

