/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.node;

import org.simantics.document.function.WikiDocumentNodeImpl;

public class Diagram extends WikiDocumentNodeImpl {

	private static final long serialVersionUID = 1316026746502673396L;
	
	public String path;
	
	@Override
	public void create(StringBuilder builder, boolean isPDF) {
		if(isPDF && !printInPDF) return;
		builder.append("{diagram:resource=" + path + "}");
		builder.append("\r\n\r\n");
	}
	
	public void synchronizePath(String path) {
		this.path = path;
	}

}
