package org.simantics.document.server.state;

import java.util.Map;
import java.util.TreeMap;

public class StateRootNode extends StateNode {

	public Map<String, StateNode> properties = new TreeMap<>();

	public Map<String, StateNode> getProperties() {
		return properties;
	}

	public StatePropertyNode getProperty(String key) {
		return (StatePropertyNode) properties.get(key);
	}

	public StatePropertyNode createProperty(String key) {
		StatePropertyNode propertyNode = new StatePropertyNode(key);
		properties.put(key, propertyNode);
		return propertyNode;
	}

	public boolean removeProperty(String key) {
		return (properties.remove(key) != null);
	}

	public void clear() {
		properties.clear();
	}

}
