package org.simantics.document.server.client;

import java.util.TreeMap;

import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;

public interface WidgetManager<D extends Document, W> {

	public W createWidget(JSONObject object);

	public void updateProperties(D document, JSONObject object, W widget);
	
	public void updateChildren(D document, JSONObject object, W widget, TreeMap<String, WidgetData> childMap);
	
    public IEventCommand eventCommand(D document, JSONObject object, W widget, String command);
	
	public String getProperty(D document, JSONObject object, W widget, String property);
	
}