package org.simantics.document.server;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.Variable;

public class PrimitiveValueVariable extends ConstantPropertyVariable {

	final private Variable property;

	public PrimitiveValueVariable(Variable parent, String name, Variable property) {
		super(parent, name, null, null);
		this.property = property;
	}

	@Override
	public <T> T getValue(ReadGraph graph) throws DatabaseException {
		return property.getValue(graph);
	}

	@Override
	public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
		return property.getValue(graph, binding);
	}

}
