/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.simantics.browsing.ui.swt.ComboBoxCellEditor2;
import org.simantics.document.linking.report.evaluator.EnumEditableNode;
import org.simantics.document.linking.report.evaluator.EvaluatorItem;
import org.simantics.document.linking.report.evaluator.EvaluatorNode;
import org.simantics.document.linking.report.evaluator.EvaluatorRoot;
import org.simantics.document.linking.report.evaluator.StringEditableNode;
import org.simantics.document.linking.report.templates.custom.EvaluatorCustomizableContent;
import org.simantics.ui.dnd.LocalObjectTransfer;

public class EvaluatorConfigurationWidget
extends Composite {
    EvaluatorCustomizableContent input;
    LocalResourceManager manager;
    EvaluatorRoot root;
    TreeViewer viewer;
    private Map<Class<? extends EvaluatorItem>, Image> imageMap = new HashMap<Class<? extends EvaluatorItem>, Image>();

    public EvaluatorConfigurationWidget(Composite parent, LocalResourceManager manager, int style) {
        super(parent, style);
        this.manager = manager;
        this.root = new EvaluatorRoot();
        this.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer((Composite)this);
        TreeViewerEditor.create((TreeViewer)this.viewer, null, (ColumnViewerEditorActivationStrategy)new DoubleClickEditorActivationStrategy((ColumnViewer)this.viewer), (int)1);
        this.viewer.setContentProvider((IContentProvider)new EvaluatorNodeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EvaluatorLabelProvider());
        this.viewer.setCellEditors(new CellEditor[]{new EvaluatorNodeCellEditor((Composite)this.viewer.getTree())});
        this.viewer.setCellModifier((ICellModifier)new EvaluatorNodeCellModifier());
        this.viewer.setColumnProperties(new String[]{"value"});
        this.viewer.setInput((Object)this.root);
        this.viewer.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                StructuredSelection sel = (StructuredSelection)EvaluatorConfigurationWidget.this.viewer.getSelection();
                EvaluatorConfigurationWidget.this.createPopupMenu(e, sel);
            }
        });
        int operations = 3;
        this.viewer.addDragSupport(operations, new Transfer[]{LocalObjectTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ISelection sel = EvaluatorConfigurationWidget.this.viewer.getSelection();
                event.doit = !sel.isEmpty();
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalObjectTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = EvaluatorConfigurationWidget.this.viewer.getSelection();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.viewer.addDropSupport(operations, new Transfer[]{LocalObjectTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if ((operation & 1) > 0) {
                    return true;
                }
                return (operation & 2) > 0;
            }

            public boolean performDrop(Object data) {
                EvaluatorItem item = (EvaluatorItem)this.determineTarget(this.getCurrentEvent());
                EvaluatorNode parent = item.getParent();
                EvaluatorItem toProcess = (EvaluatorItem)((TreeSelection)data).getFirstElement();
                if (toProcess == null) {
                    return false;
                }
                EvaluatorNode toProcessParent = toProcess.getParent();
                int index = parent.indexOf(item);
                boolean copy = false;
                if ((this.getCurrentOperation() & 1) > 0) {
                    copy = true;
                    toProcess = toProcess.copy();
                }
                switch (this.getCurrentLocation()) {
                    case 1: {
                        if (!EvaluatorConfigurationWidget.this.dropValid(parent, toProcessParent, toProcess, index, copy)) {
                            return false;
                        }
                        if (!copy && toProcessParent != null) {
                            toProcessParent.removeChild(toProcess);
                            EvaluatorConfigurationWidget.this.viewer.refresh((Object)toProcessParent);
                        }
                        parent.addChild(index, toProcess);
                        EvaluatorConfigurationWidget.this.viewer.refresh((Object)parent);
                        return true;
                    }
                    case 2: {
                        if (!EvaluatorConfigurationWidget.this.dropValid(parent, toProcessParent, toProcess, index, copy)) {
                            return false;
                        }
                        if (!copy && toProcessParent != null) {
                            toProcessParent.removeChild(toProcess);
                            EvaluatorConfigurationWidget.this.viewer.refresh((Object)toProcessParent);
                        }
                        parent.addChild(index + 1, toProcess);
                        EvaluatorConfigurationWidget.this.viewer.refresh((Object)parent);
                        return true;
                    }
                    case 3: {
                        if (item instanceof EvaluatorNode) {
                            EvaluatorNode node = (EvaluatorNode)item;
                            if (!EvaluatorConfigurationWidget.this.dropValid(node, toProcessParent, toProcess, index, copy)) {
                                return false;
                            }
                            if (!copy && toProcessParent != null) {
                                toProcessParent.removeChild(toProcess);
                                EvaluatorConfigurationWidget.this.viewer.refresh((Object)toProcessParent);
                            }
                            node.addChild(toProcess);
                            EvaluatorConfigurationWidget.this.viewer.refresh((Object)item);
                            if (!copy) {
                                return true;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
        });
        GridDataFactory.fillDefaults().span(1, 1).grab(true, true).align(4, 4).applyTo((Control)this.viewer.getTree());
    }

    private boolean dropValid(EvaluatorNode parent, EvaluatorNode toProcessParent, EvaluatorItem toProcess, int index, boolean copy) {
        return !(parent.equals(toProcessParent) ? copy && !parent.acceptChild(index, toProcess) : !parent.acceptChild(index, toProcess));
    }

    public void setInput(EvaluatorCustomizableContent content) {
        this.input = content;
    }

    public void updateContent() {
        if (this.input != null) {
            this.viewer.getTree().setEnabled(true);
            this.root.getChildren().clear();
            this.root.addChild(this.input.getItem());
            this.root.setSupportStyles(this.input.isSupportStyles());
            this.root.setSupportMultiline(this.input.isSupportMultiline());
            this.viewer.setInput((Object)this.root);
        } else {
            this.root.getChildren().clear();
            this.viewer.setInput((Object)this.root);
            this.viewer.getTree().setEnabled(false);
        }
    }

    private Image getImage(Class<? extends EvaluatorItem> cls) {
        Image image = this.imageMap.get(cls);
        if (image == null) {
            try {
                EvaluatorItem tempItem = cls.newInstance();
                ImageDescriptor imageDescriptor = tempItem.getImage();
                if (imageDescriptor != null) {
                    image = this.manager.createImage(imageDescriptor);
                    this.imageMap.put(cls, image);
                }
            }
            catch (Exception exception) {
                this.imageMap.put(cls, null);
            }
        }
        return image;
    }

    private void createPopupMenu(MenuDetectEvent event, StructuredSelection sel) {
        MenuItem menuItem;
        EvaluatorNode node;
        EvaluatorItem i = null;
        i = sel.isEmpty() ? this.root : (EvaluatorItem)sel.getFirstElement();
        final EvaluatorItem item = i;
        Menu menu = new Menu(this.viewer.getControl());
        MenuItem add = new MenuItem(menu, 64);
        add.setText("Add");
        Menu addMenu = new Menu(menu);
        add.setMenu(addMenu);
        add.setImage(this.manager.createImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_right.png")));
        MenuItem insert = new MenuItem(menu, 64);
        insert.setText("Insert");
        Menu insertMenu = new Menu(menu);
        insert.setMenu(insertMenu);
        insert.setImage(this.manager.createImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_left.png")));
        if (item instanceof EvaluatorNode) {
            node = (EvaluatorNode)item;
            for (final Class<? extends EvaluatorItem> cls : node.getPossibleChildren(true)) {
                menuItem = new MenuItem(addMenu, 8);
                menuItem.setText(cls.getSimpleName());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        node.createChild(cls);
                        EvaluatorConfigurationWidget.this.update(node);
                    }
                });
                menuItem.setImage(this.getImage(cls));
            }
        }
        if (addMenu.getItemCount() == 0) {
            add.setEnabled(false);
        }
        if (item.getParent() != null) {
            node = item.getParent();
            for (final Class<? extends EvaluatorItem> cls : node.getPossibleChildren(false)) {
                if (!EvaluatorNode.class.isAssignableFrom(cls)) continue;
                menuItem = new MenuItem(insertMenu, 8);
                menuItem.setText(cls.getSimpleName());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int index = node.indexOf(item);
                        node.removeChild(item);
                        EvaluatorNode inserted = (EvaluatorNode)node.createChild(index, cls);
                        inserted.addChild(item);
                        EvaluatorConfigurationWidget.this.update(node);
                    }
                });
                menuItem.setImage(this.getImage(cls));
            }
        }
        if (insertMenu.getItemCount() == 0) {
            insert.setEnabled(false);
        }
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText("Remove");
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EvaluatorNode parent = item.getParent();
                if (parent != null) {
                    parent.removeChild(item);
                    EvaluatorConfigurationWidget.this.update(parent);
                }
            }
        });
        menuItem2.setEnabled(item != this.root);
        menuItem2.setImage(this.manager.createImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/delete.png")));
        menu.setLocation(event.x, event.y);
        menu.setVisible(true);
    }

    private void update(EvaluatorItem item) {
        this.viewer.refresh((Object)item);
        if (item == this.root && this.root.getChildren().size() > 0) {
            this.input.setItem(this.root.getChildren().get(0));
        }
    }

    private class DoubleClickEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        public DoubleClickEditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean isLeftMouseSelect;
            boolean singleSelect = ((IStructuredSelection)EvaluatorConfigurationWidget.this.viewer.getSelection()).size() == 1;
            boolean bl = isLeftMouseSelect = event.eventType == 3 && ((MouseEvent)event.sourceEvent).button == 1;
            return singleSelect && (isLeftMouseSelect || event.eventType == 4 || event.eventType == 5);
        }
    }

    private class EvaluatorLabelProvider
    extends LabelProvider {
        private EvaluatorLabelProvider() {
        }

        public Image getImage(Object element) {
            EvaluatorItem item = (EvaluatorItem)element;
            ImageDescriptor descriptor = item.getImage();
            if (descriptor == null) {
                return null;
            }
            return EvaluatorConfigurationWidget.this.manager.createImage(descriptor);
        }
    }

    private class EvaluatorNodeCellEditor
    extends CellEditor {
        TextCellEditor textEditor;
        ComboBoxCellEditor2 enumEditor;
        CellEditor current;

        public EvaluatorNodeCellEditor(Composite parent) {
            super(parent);
        }

        Object getSelected() {
            StructuredSelection sel = (StructuredSelection)EvaluatorConfigurationWidget.this.viewer.getSelection();
            return sel.getFirstElement();
        }

        protected Control createControl(Composite parent) {
            this.textEditor = new TextCellEditor(parent);
            this.enumEditor = new ComboBoxCellEditor2(parent, new String[0]);
            this.current = this.textEditor;
            return null;
        }

        protected Object doGetValue() {
            return this.current.getValue();
        }

        protected void doSetValue(Object value) {
            Object selected = this.getSelected();
            if (selected instanceof StringEditableNode) {
                if (this.current != this.textEditor) {
                    this.current = this.textEditor;
                }
            } else if (selected instanceof EnumEditableNode) {
                if (this.current != this.enumEditor) {
                    this.current = this.enumEditor;
                }
                this.enumEditor.setItems(((EnumEditableNode)selected).getEnumearation());
            }
            this.current.setValue(value);
        }

        protected void doSetFocus() {
            this.current.setFocus();
        }

        public void activate(ColumnViewerEditorActivationEvent activationEvent) {
            this.current.activate(activationEvent);
        }

        public void activate() {
            this.current.activate();
        }

        public void deactivate() {
            this.current.deactivate();
        }

        public Control getControl() {
            return this.current.getControl();
        }
    }

    private class EvaluatorNodeCellModifier
    implements ICellModifier {
        private EvaluatorNodeCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element instanceof StringEditableNode || element instanceof EnumEditableNode;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof StringEditableNode) {
                return ((StringEditableNode)element).getValue();
            }
            if (element instanceof EnumEditableNode) {
                String[] values = ((EnumEditableNode)element).getEnumearation();
                String value = ((EnumEditableNode)element).getValue();
                int i = 0;
                while (i < values.length) {
                    if (value.equals(values[i])) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            StringEditableNode node = null;
            EnumEditableNode node2 = null;
            if (element instanceof TreeItem) {
                Object data = ((TreeItem)element).getData();
                if (data instanceof StringEditableNode) {
                    node = (StringEditableNode)data;
                } else if (data instanceof EnumEditableNode) {
                    node2 = (EnumEditableNode)data;
                }
            } else if (element instanceof StringEditableNode) {
                node = (StringEditableNode)element;
            } else if (element instanceof EnumEditableNode) {
                node2 = (EnumEditableNode)element;
            }
            if (node != null) {
                node.setValue((String)value);
                EvaluatorConfigurationWidget.this.update(node);
            } else if (node2 != null) {
                node2.setValue(node2.getEnumearation()[(Integer)value]);
                EvaluatorConfigurationWidget.this.update(node2);
            }
        }
    }

    private class EvaluatorNodeContentProvider
    implements ITreeContentProvider {
        private EvaluatorNodeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return element instanceof EvaluatorNode;
        }

        public Object getParent(Object element) {
            if (element instanceof EvaluatorItem) {
                return ((EvaluatorItem)element).getParent();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EvaluatorNode) {
                EvaluatorNode node = (EvaluatorNode)inputElement;
                return node.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EvaluatorNode) {
                EvaluatorNode node = (EvaluatorNode)parentElement;
                return node.getChildren().toArray();
            }
            return new Object[0];
        }
    }
}

