/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.html;

import java.util.List;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.html.HTMLDocument;
import org.simantics.document.linking.report.html.HTMLElement;

public class HTMLTitlePage
extends DocumentTitlePage
implements HTMLElement {
    HTMLDocument writer;

    public HTMLTitlePage(HTMLDocument writer) {
        this.writer = writer;
    }

    @Override
    public void writeTitle(List<DocumentLine> lines) throws Exception {
        this.writer.nextPage();
        for (DocumentLine line : lines) {
            String hTag = "h4";
            if (line.getHints().containsKey(Document.TextSize.class)) {
                Document.TextSize size = (Document.TextSize)((Object)line.getHints().get(Document.TextSize.class));
                switch (size) {
                    case HUGE: {
                        hTag = "h1";
                        break;
                    }
                    case LARGE: {
                        hTag = "h2";
                        break;
                    }
                    case MEDIUM: {
                        hTag = "h3";
                        break;
                    }
                    case SMALL: {
                        hTag = "h4";
                        break;
                    }
                    case TINY: {
                        hTag = "h5";
                        break;
                    }
                }
            }
            this.writer.os.println("<" + hTag + ">" + line.getLine() + "</" + hTag + ">");
        }
        this.writer.nextPage();
    }

    @Override
    public String getId() {
        return null;
    }
}

