/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report;

import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.html.HTMLDocument;
import org.simantics.document.linking.report.pdf.PDFDocument;
import org.simantics.document.linking.report.templates.CompleteStructureWriter;
import org.simantics.document.linking.report.templates.DocumentStructureWriter;
import org.simantics.document.linking.report.templates.IndexQueryReport;
import org.simantics.document.linking.report.templates.ReportWriter;

public class ExportToPDF {
    public static final int DOCUMENT_BROWSE_STRCTURE = 0;
    public static final int DOCUMENT_STRUCTURE = 1;
    public static final int DIAGRAM_STRUCTURE = 2;
    public static final int COMPLETE_STRUCTURE = 3;
    private Session session;
    private Resource model;

    public ExportToPDF(Session session, Resource model) {
        this.model = model;
        this.session = session;
    }

    public void exportPDF(String filename, int report) {
        IndexQueryReport reportWriter = null;
        switch (report) {
            case 0: {
                break;
            }
            case 1: {
                reportWriter = new DocumentStructureWriter();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                reportWriter = new CompleteStructureWriter();
                break;
            }
        }
        ExportJob job = new ExportJob(filename, reportWriter);
        job.setUser(true);
        job.schedule();
    }

    public <T> IStatus export(String filename, ReportWriter<T> reportWriter, IProgressMonitor monitor) {
        Document lineWriter = null;
        try {
            try {
                if (filename.toLowerCase().endsWith(".pdf")) {
                    lineWriter = new PDFDocument(filename, new Font("Arial", 0, 10), new Font("Arial", 1, 10));
                } else if (filename.toLowerCase().endsWith(".html") || filename.toLowerCase().endsWith(".htm")) {
                    lineWriter = new HTMLDocument(new File(filename));
                } else {
                    throw new Exception("File has unknow extension " + filename);
                }
                this.export(lineWriter, reportWriter, monitor);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.simantics.document.linking.ui", "Could not generate report", (Throwable)e);
                if (lineWriter != null) {
                    try {
                        lineWriter.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return status;
            }
        }
        finally {
            if (lineWriter != null) {
                try {
                    lineWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String status = "Report generated.";
        return new Status(0, "org.simantics.document.linking.ui", status);
    }

    private <T> void export(final Document document, final ReportWriter<T> reportWriter, final IProgressMonitor monitor) throws DatabaseException {
        this.session.syncRequest((Read)new Read<Object>(){

            public Object perform(ReadGraph graph) throws DatabaseException {
                try {
                    HashMap<Object, Object> context = new HashMap<Object, Object>();
                    context.put("model", ExportToPDF.this.model);
                    context.put(Document.class, document);
                    context.put(ReportWriter.class, reportWriter);
                    context.put("DocumentName", reportWriter.getName());
                    reportWriter.start(graph, ExportToPDF.this.model, document, context);
                    List list = reportWriter.getReportItems(graph);
                    monitor.beginTask("Write Report", list.size());
                    Object previous = null;
                    Object current = null;
                    Object next = null;
                    int i = 0;
                    while (i < list.size()) {
                        current = list.get(i);
                        previous = i > 0 ? (Object)list.get(i - 1) : null;
                        next = i < list.size() - 1 ? (Object)list.get(i + 1) : null;
                        reportWriter.write(previous, current, next, document);
                        monitor.worked(1);
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
                monitor.done();
                return null;
            }
        });
    }

    public static void exportDocumentToPDF(Resource model, String filename) {
        ExportToPDF exportPdf = new ExportToPDF(Simantics.getSession(), model);
        exportPdf.export(filename, new DocumentStructureWriter(), (IProgressMonitor)new NullProgressMonitor());
    }

    private class ExportJob
    extends Job {
        String filename;
        ReportWriter<?> reportWriter;

        public ExportJob(String filename, ReportWriter<?> reportWriter) {
            super(reportWriter.getName());
            this.filename = filename;
            this.reportWriter = reportWriter;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return ExportToPDF.this.export(this.filename, this.reportWriter, monitor);
        }
    }
}

