package org.simantics.document.linking.report.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.report.DocumentLine;


public abstract class HintNode extends EvaluatorNode{
	
	
	public abstract Object getHintValue();
	public abstract Object getHintClass();
	
	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context)
			throws DatabaseException {
		if (children.size() > 0)
			return children.get(0).getValue(graph, variable, context);
		return null;
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		if (children.size() > 0) {
			List<DocumentLine> list = children.get(0).getLines(graph, variable, context);
			for (DocumentLine line : list)
				line.getHints().put(getHintClass(), getHintValue());
			return list;
		}
		return Collections.emptyList();
	}

	
	@Override
	public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
		if (add && children.size() > 0)
			return Collections.emptyList();
		return super.getPossibleChildren(add);
	}
	
	@Override
	public boolean acceptChild(EvaluatorItem item) {
		return children.size() == 0;
	}
	
	@Override
	public boolean acceptChild(int index, EvaluatorItem item) {
		return children.size() == 0;
	}
	

}
