package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.report.DocumentLine;


public abstract class EvaluatorLeaf implements EvaluatorItem{
	

	EvaluatorNode parent;
	
	@Override
	public EvaluatorNode getParent() {
		return parent;
	}
	
	@Override
	public void setParent(EvaluatorNode parent) {
		this.parent = parent;
		
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph, org.simantics.db.layer0.variable.Variable variable, Map<Object, Object> context) throws DatabaseException {
		List<DocumentLine> lines = new ArrayList<DocumentLine>();
		String value = getValue(graph, variable,context);
		if (value != null && value.length() > 0)
			lines.add(new DocumentLine(value));
		return lines;
	}
	
	@Override
	public EvaluatorRoot getRoot() {
		if (parent == null)
			return null;
		return getRoot();
	}

}
