package org.simantics.document.linking.ge;

import java.util.Map;

import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;

public class VariableLabelRule implements LabelRule {
	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Variable.class);
	}
	
	@Override
	public Map<String, String> getLabel(ReadGraph graph, Object content)
			throws DatabaseException {
		 Variable variable = (Variable) content;

		 Resource node = variable.getPossibleRepresents(graph);
		 
		 if (node == null)
			 return null;
		
		 Layer0 l0 = Layer0.getInstance(graph);
		 DocumentLink sl = DocumentLink.getInstance(graph);
		 
		 String keys[] = Constants.SOURCE_COLUMN_KEYS;
		 String labels[] = new String[keys.length];
			
		 if (graph.isInstanceOf(node, sl.Source)) {
			Resource reference = SourceLinkUtil.getReferredDocument(graph, node);
			String comment = graph.getPossibleRelatedValue(node, sl.hasSourceComment);
			labels[0] = "";
			labels[1] = "";
			labels[3] = comment != null ? comment : "";
			
			if (reference != null) {
				if (SourceLinkUtil.isValidReference(graph, reference)) {
					labels[2] = NameUtils.getSafeLabel(graph, reference);
				} else {
					labels[2] = "Deleted reference";
				}
				
			} else {
				if (graph.getPossibleRelatedValue(node, sl.hasSourceReferenceURI, Bindings.STRING) != null) {
					labels[2] = "Reference does not exist";
				} else {
					labels[2] = "Reference has not been set";
				}
			}
			
		 } else if (graph.isInstanceOf(node, l0.Literal) || graph.isInstanceOf(node, l0.SCLValue)) {
				Statement propertyOwner = graph.getPossibleStatement(node, l0.PropertyOf);
				Resource propertyRelation = null;
				boolean defaultValue = false;
				if (propertyOwner != null) {
					propertyRelation = graph.getInverse(propertyOwner.getPredicate());
				
					
				} else {
					Resource objectInverse = graph.getPossibleObject(node, l0.HasObjectInverse);
					if (objectInverse != null) {
						propertyRelation = graph.getPossibleObject(objectInverse, l0.HasPredicate);
						defaultValue = true;
					} 
				}
				if (propertyRelation != null) {
					String propName = graph.getPossibleRelatedValue2(propertyRelation, l0.HasLabel);
					if (propName == null || propName.length() == 0)
						propName = graph.getRelatedValue(propertyRelation, l0.HasName); 
					labels[0] = propName;
					
					
				} else {
					labels[0] = "";
				}
				
				if (graph.hasValue(node)) {
					Object value = graph.getValue(node);
					labels[1] = SourceLinkUtil.getValueString(value);
				} else if (!graph.isInstanceOf(node, l0.SCLValue)){
					labels[1] = "No Value";
				} else {
					labels[1] = "";
				}
				
				if (defaultValue) {
					labels[1] +=" (default)";
				}
				labels[2] = "";
				labels[3] = "";
				
		 } else {

				labels[0] = NameUtils.getSafeLabel(graph, node);//graph.getRelatedValue(node, l0.HasName);
				if (labels[0].length() == 0)
					labels[0] = NameUtils.getSafeName(graph, node);//graph.getRelatedValue(node, l0.HasName);
				labels[1] = "";
				labels[2] = "";
				labels[3] = "";
				
				
		 }
		 return ArrayMap.make(keys, labels);
	}

}
