package org.simantics.document.linking.ge;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.silk.SilkResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;

public class VariableImageRule implements ImageRule{

	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Variable.class);
	}
	
	@Override
	public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content)
			throws DatabaseException {
		Variable v = (Variable)content;
		Resource r = v.getPossibleRepresents(graph);
		if (r == null)
			return null;
		
		DocumentLink sl = DocumentLink.getInstance(graph);
		SilkResources SILK = SilkResources.getInstance(graph);
		StructuralResource2 sr = StructuralResource2.getInstance(graph);
		SimulationResource sim = SimulationResource.getInstance(graph);
		
		if (graph.isInstanceOf(r, sl.Source)) {
			return Collections.singletonMap(Constants.REFERENCE, graph.adapt(SILK.page_white, ImageDescriptor.class));
		} else if ( graph.isInstanceOf(r, sr.Composite)) {
			return Collections.singletonMap(Constants.NAME, graph.adapt(SILK.application, ImageDescriptor.class));
		} else if ( graph.isInstanceOf(r, sr.Component)) {
			return Collections.singletonMap(Constants.NAME, graph.adapt(SILK.brick, ImageDescriptor.class));
		} else if (graph.isInstanceOf(r, sim.Model)) {
			return Collections.singletonMap(Constants.NAME, graph.adapt(SILK.chart_organisation, ImageDescriptor.class));
		} else if (content instanceof StandardGraphPropertyVariable) {
			return Collections.singletonMap(Constants.NAME, graph.adapt(SILK.cog, ImageDescriptor.class));
		}
		
		return null;
	}
}
