package org.simantics.document.linking.actions;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ge.FixAllReferencesAction;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ExceptionUtils;


public class UpdateReferencesAction implements ActionFactory {
	
	
	
	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Resource))
			return null;
		final Resource document = (Resource)target;
		return new Runnable() {
			
			@Override
			public void run() {
				try {
					Collection<Resource> coll = Simantics.getSession().syncRequest(new Read<Collection<Resource>>() {
						@Override
						public Collection<Resource> perform(ReadGraph graph)
								throws DatabaseException {
						    return findDocumentReferences(graph, document);
						}
					});
					
					if (coll == null)
						return;
					
					String dialogTitle = "Fix References";
					String dialogMessage = "Fix " + coll.size() + " old references?";
					String dialogButtonLabels[] = new String[]{"Ok","Cancel"};
					int defaultIndex = 0;
					if (coll.size() == 0) {
						dialogMessage = "Nothing to fix.";
						dialogButtonLabels = new String[]{"OK"};
						MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, MessageDialog.CONFIRM, dialogButtonLabels, defaultIndex);
						dialog.open();
						return;
					}
					MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, MessageDialog.CONFIRM, dialogButtonLabels, defaultIndex);
					if (dialog.open() != 0)
						return;
					Simantics.getSession().markUndoPoint();
					fixDocumentReferences(coll);
				} catch (DatabaseException e) {
					ExceptionUtils.logAndShowError("Cannot update references",e);
				}
				
				
			}
		};
	}
	
	public static Collection<Resource> findDocumentReferences(ReadGraph graph, Resource document) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance(graph);
        if (!graph.hasStatement(document, doc.HasNewerVersion))
            return null;
        Resource model = SourceLinkUtil.getModel(graph, document);
        if (model == null)
            return null;
        return SourceLinkUtil.findAllSources(graph, model, document);
	}
	
	public static void fixDocumentReferences(Collection<Resource> resources) throws DatabaseException {
        Simantics.getSession().syncRequest(new FixAllReferencesAction.FixAll(new Pair<Collection<Resource>, Collection<Resource>>(resources, Collections.<Resource> emptyList())));
	}

}
