/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.ui;

import org.simantics.db.Resource;
import org.simantics.db.UndoContext;
import org.simantics.db.common.ResourceArray;
import org.simantics.diagram.adapter.ConnectionVisualsLoader;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.diagram.synchronization.graph.ElementLoader;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * 
 * @Author Toni Kalajainen
 */
public class DiagramModelHints {

    public static final Key KEY_DIAGRAM_RESOURCE = new KeyOf(Resource.class, "DIAGRAM_RESOURCE");

    public static final Key KEY_DIAGRAM_MODEL_URI = new KeyOf(String.class, "DIAGRAM_MODEL_URI");

    public static final Key KEY_DIAGRAM_RUNTIME_RESOURCE = new KeyOf(Resource.class, "DIAGRAM_RUNTIME_RESOURCE");

    public static final Key KEY_DIAGRAM_RESOURCE_ARRAY = new KeyOf(ResourceArray.class, "DIAGRAM_RESOURCE_ARRAY");

    /**
     * A hint for defining and extra pass for loading/initializing an element
     * after the current pass. It is possible to request for infinitely many
     * passes by always setting a new ElementLoader hint into the loaded element
     * during loading. The loading process will loop until none of the loaded
     * elements have a loader hint. An {@link ElementFactory} or
     * {@link ElementLoader} is only allowed to set this hint on the element it
     * is loading, not on any other element.
     */
    public static final Key KEY_ELEMENT_LOADER = new KeyOf(ElementLoader.class, "ELEMENT_LOADER");

    /**
     * Allows customizable external control over how the an IElement gets
     * written into backing storage (graph) when it is added to a diagram.
     * 
     * This hint will be removed after it has been used by the synchronizer.
     */
    public static final Key KEY_ELEMENT_WRITER = new KeyOf(ElementWriter.class, "ELEMENT_WRITER");

    /**
     * TODO: what is this for?
     */
    public static final Key KEY_ACTIVE_EXPERIMENT = new KeyOf(IExperiment.class, "ACTIVE_EXPERIMENT");

    /**
     * Operating UI requires this for some unknown reason.
     * TODO: find out what this is
     */
    public static final Key KEY_SESSION_ID = new KeyOf(String.class, "SESSION_ID");

    /**
     * Externally definable rules for topological modeling, i.e. how nodes and
     * edges and their connectivity is bounded.
     */
    public static final Key KEY_MODELING_RULES = new KeyOf(IModelingRules.class, "MODELING_RULES");

    /**
     * For customizing how connection segments are loaded for a diagram. Give
     * this hint as an initial hint to {@link IDiagramLoader} to use your own
     * version in diagram loading.
     */
    public static final Key KEY_CONNECTION_VISUALS_LOADER = new KeyOf(ConnectionVisualsLoader.class, "CONNECTION_VISUALS_LOADER");

    /**
     * For storing an {@link UndoContext} in {@link IDiagram} or
     * {@link ICanvasContext}.
     * 
     * @deprecated to be removed down, do not use anymore
     */
    public static final Key KEY_UNDO_CONTEXT = new KeyOf(UndoContext.class, "UNDO_CONTEXT");

    /**
     * An informational hint that functions only as a trigger for listeners to
     * tell that the diagram contents have changed and that the changes have
     * been noticed and updated into the runtime diagram model ({@link IDiagram}
     * ). The hint is given the value {@link Boolean#TRUE} every time the update
     * happens, i.e. the value is of no importance, only the trigger aspect is.
     */
    public static final Key KEY_DIAGRAM_CONTENTS_UPDATED = new KeyOf(Boolean.class, "DIAGRAM_CONTENTS_UPDATED");


}
