/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.util.Arrays;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;

/**
 * @author Tuukka Lehtonen
 */
public class PropertyModification extends ModificationAdapter {
    private final Resource owner;
    private final Resource relation;
    private final Resource type;
    private final Object value;
    private final Binding binding;

    public PropertyModification(Resource propertyOwner, Resource propertyRelation, Resource propertyType, Object value, Binding binding) {
        super(LOW_PRIORITY);
        this.owner = propertyOwner;
        this.relation = propertyRelation;
        this.type = propertyType;
        this.value = value;
        this.binding = binding;
    }
    
	private final boolean arrayEquals(Object av1, Object av2) {
		if (av2 == null)
			return false;
		Class<?> c1 = av1.getClass().getComponentType();
		Class<?> c2 = av2.getClass().getComponentType();
		if (c2 == null || !c1.equals(c2))
			return false;
		boolean p1 = c1.isPrimitive();
		boolean p2 = c2.isPrimitive();
		if (p1 != p2)
			return false;
		if (!p1)
			return Arrays.equals((Object[]) av1, (Object[]) av2);
		if (boolean.class.equals(c1))
			return Arrays.equals((boolean[]) av1, (boolean[]) av2);
		else if (byte.class.equals(c1))
			return Arrays.equals((byte[]) av1, (byte[]) av2);
		else if (int.class.equals(c1))
			return Arrays.equals((int[]) av1, (int[]) av2);
		else if (long.class.equals(c1))
			return Arrays.equals((long[]) av1, (long[]) av2);
		else if (float.class.equals(c1))
			return Arrays.equals((float[]) av1, (float[]) av2);
		else if (double.class.equals(c1))
			return Arrays.equals((double[]) av1, (double[]) av2);
		throw new RuntimeException("??? Contact application querySupport.");
	}

    private boolean sameValue(Object oldValue, Object newValue) {
		if (newValue.getClass().isArray()) {
			return arrayEquals(newValue, oldValue);
		} else {
			return newValue.equals(oldValue);
		}
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
    	
    	Object existing = g.getPossibleRelatedValue(owner, relation, binding);
    	if(!sameValue(existing, value)) {
        	g.markUndoPoint();
            DiagramGraphUtil.setRelatedValue(g, owner, relation, type, value, binding);
    		// Add comment to change set.
    		CommentMetadata cm = g.getMetadata(CommentMetadata.class);
    		g.addMetadata(cm.add("Changed property " + NameUtils.getSafeName(g, relation)));
    	}

    }
}