/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * An Eclipse property tester for normal elements.
 * 
 * @author Tuukka Lehtonen
 */
public class ElementPropertyTester extends PropertyTester {

    /**
     * Tests if the received element resource is mapped to a counterpart.
     * Default expected value is true.
     */
    private static final String MAPPED = "mapped";

    @Override
    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        final Resource resource = ResourceAdaptionUtils.toSingleResource(receiver);
        if (resource == null)
            return false;

        Session session = Simantics.peekSession();
        if (session == null)
            return false;

        if (DatabaseJob.inProgress())
            return false;

        try {
            return RequestUtil.trySyncRequest(
                    session,
                    SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT,
                    SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT,
                    false,
                    new UniqueRead<Boolean>() {
                @Override
                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return Boolean.valueOf(doTest(g, resource, property, args, expectedValue));
                }
            });
        } catch (DatabaseException | InterruptedException e) {
            // Purposefully not logging these exceptions, there might be way too
            // many even under normal circumstances.
            // TODO: add debug tracing options controlling the printing of these exceptions
            return false;
        }
    }

    private boolean doTest(ReadGraph graph, Resource resource, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (MAPPED.equals(property)) {
        	return graph.hasStatement(resource, ModelingResources.getInstance(graph).ElementToComponent);
        } 
        return false;
    }

}
