/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram;

import java.util.Properties;

public class Logger {
    public static final boolean ECHO = false;
    public static final Properties defaultProperties = new Properties();
    static {
        defaultProperties.put("log4j.rootCategory", "ERROR, default");
        defaultProperties.put("log4j.appender.default", "org.apache.log4j.FileAppender");
        defaultProperties.put("log4j.appender.default.File", "diagram.log");
        defaultProperties.put("log4j.appender.default.append", "false");
        defaultProperties.put("log4j.appender.default.layout", "org.apache.log4j.PatternLayout");
        defaultProperties.put("log4j.appender.default.layout.ConversionPattern", "%-6r [%15.15t] %-5p %30.30c - %m%n");
    }
    private static LogManager defaultLogManager = new LogManager(defaultProperties);
    private static final Logger defaultErrorLogger = new Logger(LogManager.class);
    private org.apache.log4j.Logger logger;
    Logger(Class<?> clazz) {
    	logger = defaultLogManager.getLogger(clazz);
    }

    /**
     * Log a trace event.
     * 
     * @param message message of the trace
     * @param exception the exception, or <code>null</code>
     */
    public void logTrace(String message, Throwable exception) {
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        logger.trace(message, exception);
    }

    /**
     * Log an info event.
     * 
     * @param message message of the info
     * @param exception the exception, or <code>null</code>
     */
    public void logInfo(String message, Throwable exception) {
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        logger.info(message, exception);
    }

    /**
     * Log an error event.
     * 
     * @param message message of the error
     * @param exception the exception, or <code>null</code>
     */
    public void logError(String message, Throwable exception) {
        // Errors are much more useful with a stack trace!
        if (exception == null) {
            exception = new RuntimeException();
        }
        logger.error(message, exception);
    }

    public static Logger getDefault() {
        return defaultErrorLogger;
    }
    
    public static LogManager getDefaultLogManager() {
        return defaultLogManager;
    }
    public static void defaultLogError(Throwable exception) {
        getDefault().logError(exception.getLocalizedMessage(), exception);
        if(ECHO) exception.printStackTrace();
    }
    public static void defaultLogError(String message) {
        getDefault().logError(message, null);
        if(ECHO)
            System.err.println(message);
    }
    public static void defaultLogError(String message, Throwable exception) {
        getDefault().logError(message, exception);
        if(ECHO)
            System.err.println(message);
    }
    public static void defaultLogInfo(String message) {
        getDefault().logInfo(message, null);
        if(ECHO)
            System.err.println(message);
    }
    public static void defaultLogTrace(String message) {
        getDefault().logTrace(message, null);
        if(ECHO)
            System.err.println(message);
    }
}
