package org.simantics.diagram.profile.request;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;

public class ReferencedProfileEntries extends ResourceRead<Collection<Resource>> {

	public ReferencedProfileEntries(Resource part) {
		super(part);
	}

	public HashSet<Resource> process(ReadGraph graph, Resource resource, HashSet<Resource> result) throws DatabaseException {

		DiagramResource DIA = DiagramResource.getInstance(graph);
		
    	if(graph.isInstanceOf(resource, DIA.Profile)) {

    		for(Resource child : ProfileUtils.getProfileChildren(graph, resource)) {
    			process(graph, child, result);
    		}
    		
    	} else if(graph.isInstanceOf(resource, DIA.ProfileEntry)) {
    		
    		result.add(resource);

		}
    	
    	return result;
    	
	}
	
	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
		return process(graph, resource, new HashSet<Resource>());
	}
	
}
