/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection.segments;

import org.simantics.diagram.connection.RoutePoint;

/**
 * @author Hannu Niemist&ouml;
 */
public class Segment {
    public final RoutePoint p1;
    public final RoutePoint p2;
    
    public Segment(RoutePoint p1, RoutePoint p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public boolean isDegenerated() {
        return p1.getX() == p2.getX() && p1.getY() == p2.getY();
    }
}
