/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection;

import gnu.trove.map.hash.THashMap;

import java.util.Comparator;

public abstract class RoutePoint {
    
    public static final Comparator<RoutePoint> X_COMPARATOR = new Comparator<RoutePoint>() {
        @Override
        public int compare(RoutePoint a, RoutePoint b) {
            return Double.compare(a.x, b.x);
        }
    };
    
    public static final Comparator<RoutePoint> Y_COMPARATOR = new Comparator<RoutePoint>() {
        @Override
        public int compare(RoutePoint a, RoutePoint b) {
            return Double.compare(a.y, b.y);
        }
    };
    
    double x;
    double y;

    public RoutePoint() {
    }
    
    public RoutePoint(double x, double y) {
        this.x = x;
        this.y = y;
    }
    
    public double getX() {
        return x;
    }
    
    public double getY() {
        return y;
    }

    void removeFromOther(RouteLine routeLine) {
    }

    public boolean isNear(double x2, double y2, double tolerance) {
        double dx = x2-x;
        double dy = y2-y;
        
        return dx*dx + dy*dy <= tolerance*tolerance;
    }

	abstract RoutePoint copy(THashMap<Object, Object> map);
	
	
	public void setX(double x) {
		this.x = x;
	}
	
	public void setY(double y) {
		this.y = y;
	}
}
