/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection;

import gnu.trove.map.hash.THashMap;

import java.io.Serializable;

public class RouteLink extends RoutePoint implements Serializable {

    private static final long serialVersionUID = 1446230300676765986L;

    RouteLine a;
    RouteLine b;

    /**
     * Default constructor for copy-method
     */
    private RouteLink() {
    }
    
    RouteLink(RouteLine a, RouteLine b) {
        this.a = a;
        this.b = b;
        a.addPoint(this);
        b.addPoint(this);
    }
    
    void removeFromOther(RouteLine other) {
        if(a == other)
            b.points.remove(this);
        else
            a.points.remove(this);
    }

    public RouteLine getA() {
        return a;
    }
    
    public RouteLine getB() {
        return b;
    }

    public void setA(RouteLine rl) {
        this.a = rl;
        rl.addPoint(this);
        if(b.isTransient())
            b.terminal.line = rl;
    }
    
    public void setB(RouteLine rl) {
        this.b = rl;
        rl.addPoint(this);
        if(a.isTransient())
            a.terminal.line = rl;
    }

    public RouteLine getOther(RouteLine line) {
        if(a == line)
            return b;
        else
            return a;
    }

    public void replace(RouteLine rl1, RouteLine rl2) {
        if(a == rl1)
            setA(rl2);
        else if(b == rl1)
            setB(rl2);
    }

	@Override
	RouteLink copy(THashMap<Object, Object> map) {
		RouteLink copy = (RouteLink)map.get(this);
		if(copy == null) {
			copy = new RouteLink();
			map.put(this, copy);
			copy.a = a.copy(map);
			copy.b = b.copy(map);			
			copy.x = x;
			copy.y = y;
		}
		return copy;
	}
    
}
