/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.ui.graph;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;

public class GraphicalDebuggerView extends ViewPart {

    public static final String VIEW_ID              = "org.simantics.debug.graphicalDebugger";

//    private final boolean      DEFAULT_RECYCLE_VIEW = true;

    private ResourceInput      input;

    private Session            session;

    private GraphicalDebugger      debugger;

//    private Action             recycleToggle;
    private Action             backAction;
    private Action             forwardAction;
    private Action             refreshAction;
    private Action             homeAction;
    private Action			   increaseDepthAction;
    private Action			   decreaseDepthAction;

    @Override
    public void createPartControl(Composite parent) {
//      System.out.println("koss: " + getViewSite().getSecondaryId());
        session = Simantics.getSession();

        // Initialize input
        String sid = getViewSite().getSecondaryId();
        Resource r = null;
        if (sid != null) {
            input = ResourceInput.unmarshall(sid);
            try {
                r = input.toResource(session);
            } catch (DatabaseException e) {
                ErrorLogger.defaultLogError(e);
            }
        }

        // Create UI
        parent.setLayout(LayoutUtils.createNoBorderGridLayout(1));
        debugger = new GraphicalDebugger(parent, SWT.NONE, session, r);
        debugger.defaultInitializeUI();

        // Contribute actions
        makeActions();
        contributeActions(getViewSite().getActionBars());
        updateActionStates();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void makeActions() {
//        recycleToggle = new RecycleToggle();
//        recycleToggle.setChecked(DEFAULT_RECYCLE_VIEW);

        backAction = new BackAction();
        forwardAction = new ForwardAction();
        refreshAction = new RefreshAction();
        homeAction = new HomeAction();
        increaseDepthAction = new IncreaseDepthAction();
        decreaseDepthAction = new DecreaseDepthAction();
    }

    private void contributeActions(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(backAction);
        toolBar.add(forwardAction);
        toolBar.add(new Separator());
        toolBar.add(refreshAction);
        toolBar.add(homeAction);
        toolBar.add(new Separator());
        toolBar.add(decreaseDepthAction);
        toolBar.add(increaseDepthAction);
//        toolBar.add(recycleToggle);
    }

    @Override
    public void setFocus() {
        if (debugger != null)
            debugger.setFocus();
    }

    private void refreshBrowser() {
        debugger.refreshBrowser();
    }

//    class RecycleToggle extends Action {
//        public RecycleToggle() {
//            super("Open New Views", Action.AS_CHECK_BOX);
//            setImageDescriptor(Activator.getImageDescriptor("icons/reload.gif"));
//            setToolTipText("Toggles whether or not to open new views when resource links are clicked.");
//        }
//    }
//
    class RefreshAction extends Action {
        public RefreshAction() {
            super("Refresh", BundleUtils.getImageDescriptorFromPlugin(SimanticsUI.PLUGIN_ID, "icons/refresh.gif"));
        }
        @Override
        public void run() {
            refreshBrowser();
        }
    }

    class BackAction extends Action {
        public BackAction() {
            super("Back", Action.AS_PUSH_BUTTON);
            setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_BACK));
            setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_BACK_DISABLED));
        }
        @Override
        public void run() {
            back();
        }
    }

    class ForwardAction extends Action {
        public ForwardAction() {
            super("Forward", Action.AS_PUSH_BUTTON);
            setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD));
            setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD_DISABLED));
        }
        @Override
        public void run() {
            forward();
        }
    }

    class HomeAction extends Action {
        public HomeAction() {
            super("Home", Action.AS_PUSH_BUTTON);
            setToolTipText("Navigate to root library");
            setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_ETOOL_HOME_NAV));
            setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_ETOOL_HOME_NAV_DISABLED));
        }
        @Override
        public void run() {
            navigateHome();
        }
    }
    
    class DecreaseDepthAction extends Action {
        public DecreaseDepthAction() {
            super("Decrease", Action.AS_PUSH_BUTTON);
            setToolTipText("Decrease Depth");
            setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_BACK));
            setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_BACK_DISABLED));
        }
        @Override
        public void run() {
            decreaseDepth();
        }
    }

    class IncreaseDepthAction extends Action {
        public IncreaseDepthAction() {
            super("Increase", Action.AS_PUSH_BUTTON);
            setToolTipText("Increase Depth");
            setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD));
            setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_TOOL_FORWARD_DISABLED));
        }
        @Override
        public void run() {
            increaseDepth();
        }
    }

    private void back() {
        debugger.back();
    }

    private void forward() {
        debugger.forward();
    }
    
    private void decreaseDepth() {
        debugger.setDepth(debugger.getDepth() - 1);
    }

    private void increaseDepth() {
    	 debugger.setDepth(debugger.getDepth() + 1);
    }

    private void navigateHome() {
    	Resource rootLibrary = session.getRootLibrary();
    	debugger.changeLocation(rootLibrary);
    }

    private void updateActionStates() {
        backAction.setEnabled(debugger.hasBackHistory());
        forwardAction.setEnabled(debugger.hasForwardHistory());
    }

}
