/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.content;

import java.util.Arrays;
import java.util.Comparator;

import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.debug.browser.internal.Activator;

public class ResourceBrowserRewriterRepository {
    private static ServiceTracker<ResourceBrowserRewriter, ResourceBrowserRewriter> TRACKER;

    private static final Comparator<ResourceBrowserRewriter> REWRITER_COMPARATOR =
            new Comparator<ResourceBrowserRewriter>() {
        @Override
        public int compare(ResourceBrowserRewriter o1,
                ResourceBrowserRewriter o2) {
            return Double.compare(o1.getPriority(), o2.getPriority());
        }
    };

    public static ResourceBrowserRewriter[] getRewriters() {
        if(TRACKER == null) {
            BundleContext context = Activator.getContext();
            TRACKER = new ServiceTracker<ResourceBrowserRewriter, ResourceBrowserRewriter>(
                    context, ResourceBrowserRewriter.class, null);
            TRACKER.open();
        }
        ResourceBrowserRewriter[] rewriters =
                TRACKER.getServices(new ResourceBrowserRewriter[TRACKER.getTrackingCount()]);
        Arrays.sort(rewriters, REWRITER_COMPARATOR);
        return rewriters;
    }
}
