/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import java.io.File;
import java.security.Permission;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.junit.After;
import org.junit.Before;
import org.simantics.SimanticsPlatform;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.management.SessionContext;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.testing.common.DatabaseState;
import org.simantics.db.testing.impl.Configuration;
import org.simantics.layer0.Layer0;
import org.simantics.utils.FileUtils;

public abstract class TestBase {
    public static final boolean DEBUG;
    public static final String ROOT_LIBRARY_URI = "http:/";
    private NoExitSecurityManager noExitSecurityManager;
    private SecurityManager securityManager;
    protected DatabaseState state;
    public Throwable exception2;
    protected Layer0 L0;
    static boolean printStart;
    public static final ArrayList<String> initialWorkspaceFiles;

    static {
        Configuration.get().getClass();
        DEBUG = false;
        printStart = true;
        initialWorkspaceFiles = FileUtils.createFileFilter((File)Platform.getLocation().toFile(), null);
    }

    public static void printStart(Object t) {
        if (printStart) {
            System.out.println("Test is " + t.getClass().getName());
        }
    }

    protected static void setPrintStart(boolean value) {
        printStart = value;
    }

    public Resource getProjectResource() {
        return SimanticsPlatform.INSTANCE.projectResource;
    }

    @Before
    public void setUp() throws Exception {
        TestBase.printStart(this);
        this.securityManager = System.getSecurityManager();
        this.noExitSecurityManager = new NoExitSecurityManager(this.state.getSession());
        System.setSecurityManager(this.noExitSecurityManager);
        Session session = this.state.getSession();
        this.L0 = Layer0.getInstance((RequestProcessor)session);
    }

    @After
    public void tearDown() throws Exception {
        if (this.noExitSecurityManager != null) {
            System.setSecurityManager(this.securityManager);
            this.noExitSecurityManager.dispose();
            this.noExitSecurityManager = null;
        }
        this.L0 = null;
        this.state = null;
        this.exception2 = null;
        this.securityManager = null;
        TestBase.commonTearDown();
    }

    public static void commonTearDown() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        rt.gc();
        rt.gc();
        if (DEBUG) {
            System.out.println("Max=" + rt.maxMemory() + " tot=" + rt.totalMemory() + " fre=" + rt.freeMemory());
        }
    }

    public static String getRandomString() {
        return UUID.randomUUID().toString();
    }

    protected Session getSession() throws DatabaseException {
        return this.state.getSession();
    }

    protected SessionContext getSessionContext() {
        return this.state.getSessionContext();
    }

    protected void checkException() throws DatabaseException {
        if (this.exception2 != null) {
            if (this.exception2 instanceof DatabaseException) {
                throw (DatabaseException)this.exception2;
            }
            throw new DatabaseException(this.exception2);
        }
    }

    protected boolean hasException() {
        return this.exception2 != null;
    }

    protected Throwable getException() {
        return this.exception2;
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    protected static void fail() {
        throw new AssertionError();
    }

    protected void fail(String cause) {
        throw new AssertionError((Object)cause);
    }

    protected void fail(String cause, Object a) {
        Throwable t;
        Throwable c;
        if (a instanceof Throwable && (c = (t = (Throwable)a).getCause()) != null) {
            throw new AssertionError((Object)new Error(t.getMessage(), c));
        }
        throw new AssertionError((Object)(String.valueOf(cause) + " " + a));
    }

    protected void assertEquals(Object a, Object b) {
        if (!a.equals(b)) {
            throw new AssertionError();
        }
    }

    protected void assertEquals(int a, int b) {
        if (a != b) {
            throw new AssertionError();
        }
    }

    protected void assertEquals(double a, double b, double tolerance) {
        if (Math.abs(a - b) > tolerance) {
            throw new AssertionError();
        }
    }

    protected void assertLess(double a, double b) {
        if (a >= b) {
            throw new AssertionError((Object)(String.valueOf(a) + " is not less than " + b));
        }
    }

    protected void assertLess(double a, double b, String info) {
        if (a >= b) {
            System.err.println("assertion info:\n" + info + "\n");
            throw new AssertionError((Object)(String.valueOf(a) + " is not less than " + b));
        }
    }

    protected void assertEquals(String a, String b) {
        if (!a.equals(b)) {
            throw new AssertionError();
        }
    }

    protected void assertEquals(String message, int a, int b) {
        if (a != b) {
            throw new AssertionError((Object)message);
        }
    }

    protected void assertEquals(String message, boolean a, boolean b) {
        if (a != b) {
            throw new AssertionError((Object)message);
        }
    }

    protected void assertNotNull(Object a) {
        if (a == null) {
            throw new AssertionError();
        }
    }

    protected void assertNotNull(String message, Object a) {
        if (a == null) {
            throw new AssertionError((Object)message);
        }
    }

    protected void assertTrue(String message, boolean a) {
        if (!a) {
            throw new AssertionError((Object)message);
        }
    }

    protected void assertTrue(boolean a) {
        if (!a) {
            throw new AssertionError();
        }
    }

    protected void assertFalse(boolean a) {
        if (a) {
            throw new AssertionError();
        }
    }

    protected void assertFalse(String message, boolean a) {
        if (a) {
            throw new AssertionError((Object)message);
        }
    }

    protected abstract class AsyncReadQuery<Result>
    implements AsyncRead<Result> {
        protected Result result = null;

        protected AsyncReadQuery() {
        }

        public abstract void run(AsyncReadGraph var1) throws Throwable;

        public void perform(AsyncReadGraph graph, AsyncProcedure<Result> procedure) {
            block3: {
                try {
                    this.run(graph);
                }
                catch (Throwable t) {
                    if (DEBUG) {
                        new Exception().printStackTrace();
                        t.printStackTrace();
                    }
                    if (TestBase.this.exception2 != null) break block3;
                    TestBase.this.exception2 = t;
                }
            }
        }
    }

    protected static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = -1982617086752946683L;
        public final int status;

        public ExitException(int status) {
            super("There is no escape!");
            this.status = status;
        }
    }

    private static class NoExitSecurityManager
    extends SecurityManager {
        Session session;

        NoExitSecurityManager(Session session) {
            this.session = session;
        }

        public void dispose() {
            this.session = null;
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
            super.checkExit(status);
            if (this.session != null) {
                try {
                    ((LifecycleSupport)this.session.getService(LifecycleSupport.class)).close(0L, true);
                }
                catch (ServiceNotFoundException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
            }
        }
    }

    protected abstract class ReadQuery<Result>
    implements Read<Result> {
        protected Result result = null;

        protected ReadQuery() {
        }

        public abstract void run(ReadGraph var1) throws Throwable;

        public Result perform(ReadGraph graph) {
            try {
                this.run(graph);
                return this.result;
            }
            catch (Throwable t) {
                if (DEBUG) {
                    new Exception().printStackTrace();
                    t.printStackTrace();
                }
                if (TestBase.this.exception2 == null) {
                    TestBase.this.exception2 = t;
                }
                return null;
            }
        }
    }

    protected abstract class TestAsyncReadRequest
    extends AsyncReadQuery<Object> {
        protected TestAsyncReadRequest() {
        }

        public int getFlags() {
            return 0;
        }

        public int threadHash() {
            return 0;
        }
    }

    protected abstract class TestReadRequest
    extends ReadQuery<Object> {
        protected TestReadRequest() {
        }
    }

    protected abstract class WriteOnlyQuery
    extends WriteOnlyRequest {
        protected WriteOnlyQuery() {
        }

        public abstract void run(WriteOnlyGraph var1) throws Throwable;

        public final void perform(WriteOnlyGraph g) {
            try {
                this.run(g);
            }
            catch (Throwable t) {
                new Exception().printStackTrace();
                t.printStackTrace();
                if (TestBase.this.exception2 == null) {
                    TestBase.this.exception2 = t;
                }
                throw new RuntimeException("Wrapping thrown non exception to exception.", t);
            }
        }

        public void run(WriteGraph g) throws Throwable {
            this.run((WriteOnlyGraph)g);
        }
    }
}

