/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.common;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.TestSettings;

public class AcornTestHandler {
    private final Driver driver = Manager.getDriver((String)"acorn");
    private final File dbFolder;

    AcornTestHandler(TestSettings testSettings, String dbFolderName) throws DatabaseException {
        if (this.driver == null) {
            throw new IllegalArgumentException("No driver found for acorn!");
        }
        this.dbFolder = dbFolderName == null ? Platform.getLocation().append("db").toFile() : new File(dbFolderName);
    }

    void initNew() throws DatabaseException {
        Driver.Management m = this.getManagement();
        if (m.exist()) {
            m.delete();
        }
        m.create();
    }

    void initIfNeccessary() throws DatabaseException {
        Driver.Management m = this.getManagement();
        if (!m.exist()) {
            m.create();
        }
    }

    public Session getSession() throws DatabaseException {
        Properties props = new Properties();
        props.setProperty("user", "Default User");
        props.setProperty("password", "");
        return this.driver.getSession(this.dbFolder.getAbsolutePath(), props);
    }

    public ServerI getServer() throws DatabaseException {
        return this.driver.getServer(this.dbFolder.getAbsolutePath(), null);
    }

    public Driver.Management getManagement() throws DatabaseException {
        return this.driver.getManagement(this.dbFolder.getAbsolutePath(), null);
    }
}

