/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.base;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.osgi.framework.BundleContext;
import org.simantics.db.testing.cases.FreshDatabaseTest;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.compiler.testing.repository.TestRepository;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.internal.ServiceBasedModuleSourceRepository;
import org.simantics.scl.osgi.internal.ServiceBasedTestRepository;

public class SCLScriptTestBase
extends FreshDatabaseTest {
    private Map<String, TestRunnable> testRunnables = new THashMap();
    @Rule
    public TestName testName = new TestName();

    public SCLScriptTestBase() {
        BundleContext context = Activator.getContext();
        ArrayList runnables = new ArrayList();
        ((TestRepository)context.getService(context.getServiceReference(TestRepository.class))).collectTests(runnables);
        for (TestRunnable runnable : runnables) {
            this.testRunnables.put(runnable.getName(), runnable);
        }
    }

    protected void test() {
        this.test(-1);
    }

    protected void test(int timeout) {
        this.testImpl(timeout);
    }

    private void testImpl(int timeout) {
        SCLOsgi.SOURCE_REPOSITORY = new ServiceBasedModuleSourceRepository(Activator.getContext());
        SCLOsgi.MODULE_REPOSITORY = new ModuleRepository(SCLOsgi.SOURCE_REPOSITORY);
        SCLOsgi.TEST_REPOSITORY = new ServiceBasedTestRepository(Activator.getContext());
        String testName = this.resolveTestName();
        TestRunnable runnable = this.testRunnables.get(testName);
        if (timeout > -1) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    String processName = ManagementFactory.getRuntimeMXBean().getName();
                    System.out.println("PID: " + processName);
                    String PID = processName.split("@")[0];
                    String command = "taskkill /F /PID " + PID;
                    System.out.println("Command: " + command);
                    try {
                        Runtime.getRuntime().exec(command);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, timeout * 1000);
            try {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    timer.cancel();
                }
            }
            finally {
                timer.cancel();
            }
        } else {
            try {
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String resolveTestName() {
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = this.getClass();
        while (clazz.getName() != SCLScriptTestBase.class.getName()) {
            String[] classNameParts = clazz.getName().split("\\.");
            sb.insert(0, "/");
            sb.insert(0, classNameParts[classNameParts.length - 1]);
            clazz = clazz.getSuperclass();
        }
        sb.append(this.testName.getMethodName());
        return sb.toString();
    }
}

