/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;
import java.nio.ByteBuffer;

public class GetClusterNewFunction extends AbstractFunction {
    public byte[] clusterUID = null;
    public int inflateSize = 0;
    public ByteBuffer deflated = null;
    public GetClusterNewFunction() {
        super(MessageNumber.GetClusterNewRequest, MessageNumber.GetClusterNewResponse);
    }
    public GetClusterNewFunction(byte[] clusterUID) {
        super(MessageNumber.GetClusterNewRequest, MessageNumber.GetClusterNewResponse);
        this.clusterUID = clusterUID;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.put(clusterUID);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        inflateSize = dataBuffer.get(inflateSize);
        deflated = dataBuffer.get(deflated);
        gotResponse();
    }
}
