/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementatio
 *******************************************************************************/
package org.simantics.db.server.internal;

import java.net.InetSocketAddress;

/**
 * @author J-P Laine
 */
public class ServerAddress {
    private InetSocketAddress socketAddress;
    private String dbid;

    public ServerAddress(String hostAndPort, String dbid) {
        this(hostAndPort);
        this.dbid = dbid;
    }

    public ServerAddress(String hostAndPort) {
        assert (hostAndPort != null);

        String[] split = hostAndPort.split(":");
        if (split.length != 2)
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        this.socketAddress = InetSocketAddress.createUnresolved(split[0], Integer.parseInt(split[1]));
        this.dbid = null;
    }

    public ServerAddress(String host, int port) {
        assert (host != null);
        this.socketAddress = new InetSocketAddress(host, port);
        this.dbid = null;
    }

    public ServerAddress(String host, int port, String dbid) {
        assert (host != null);
        this.socketAddress = InetSocketAddress.createUnresolved(host, port);
        this.dbid = dbid;
    }

    public ServerAddress(InetSocketAddress socketAddress) {
        assert (socketAddress != null);
        this.socketAddress = socketAddress;
        this.dbid = null;
    }

    public ServerAddress(InetSocketAddress socketAddress, String dbid) {
        assert (socketAddress != null);
        this.socketAddress = socketAddress;
        this.dbid = dbid;
    }

    public InetSocketAddress getAddress() {
        return socketAddress;
    }

    public String getDbid() {
        return dbid;
    }

    @Override
    public int hashCode() {
        return socketAddress.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (other == null || !(getClass().equals(other.getClass()))) return false;
        ServerAddress r = (ServerAddress) other;
        return r.socketAddress.equals(socketAddress) && (r.dbid != null && r.dbid.equals(dbid) || r.dbid == null && dbid == null);
    }

    @Override
    public String toString() {
        if(dbid != null) {
            return socketAddress.toString()+" / "+dbid;
        } else {
            return socketAddress.toString();
        }
    }
}
